require "/interface/sexbound/sexui/submodule.lua"

SexUI.POV = SexUI.Submodule.new()
SexUI.POV_mt = {
    __index = SexUI.POV
}
require "/interface/sexbound/sexui/submodule/pov/part.lua"

--- Instantiates a new instance
-- @param parant the parent instance
-- @param config a table of config options
function SexUI.POV.new(parent, config)
    local self = setmetatable({
        --[[actor1HandLVariantIndex = 1,        -- HANDS! FINGERS! WATCH OUT FOR THOSE WRIST-ROCKETS!
        actor1HandRVariantIndex = 1,
        actor1HandVariantTimer = 0,
        actor1HandVariantChangeTimeout = 0,]]
        animationCycle = config.animationCycle or 1,
        animationRate = 1,
        animationTimer = 0,
        frameCount = config.frameCount or 5,
        frameIndex = 1,
        frameName = "",
        parts = {},
        animationType = 0,
        penetrationType = 1,
        
        -- Variables for TemTem's Cutscenes
        cutscene1Setup = false,
        cutscene2Setup = false,
		climaxStage = 0,
		ScenePenType = 1,
        Setup1Name = "",  -- TEMTEM2 - saving old setup name page fot json reload
		Setup2Name = "",
		mActor = nil,
		mActorOldInfo = nil,
        climaxSequence = "123456789a", -- order of which the climax animation will play
		oldVersion = false -- using old cutscene style or new one
    }, SexUI.POV_mt)

    self:init(parent, config)
    self.canvas = widget.bindCanvas("pov")
    return self
end

--- Renders the animation parts managed by this instance
function SexUI.POV:render()
    -- Clears the interface to update it
    self.canvas:clear()
    
    -- If the mod can't find art for any actor, give up.
    if isEmpty(self.parts) then
        return
    end
    
    local PlayFinish = false -- TEMTEM2 listening to whenever play a finish climax transition. 
        if 	(self.mActor[1].statusProperty.isClimaxing and self.mActor[1].climax.currentPoints < 8 and self.mActor[1].climax.currentPoints > 5 and not self.mActor[2].statusProperty.isClimaxing) or 
			(self.mActor[2].statusProperty.isClimaxing and self.mActor[2].climax.currentPoints < 8 and self.mActor[2].climax.currentPoints > 5 and not self.mActor[1].statusProperty.isClimaxing) then
			PlayFinish = true
		end
        
		if 	(self.mActor[1].statusProperty.isClimaxing and self.mActor[2].statusProperty.isClimaxing and 
			self.mActor[1].climax.currentPoints < 8 and self.mActor[2].climax.currentPoints < 8) then
			PlayFinish = true
		end
        
		--TEMTEM2 if climaxing and climax about to end play the last sequence to transition back to loop 
		if string.find(self.frameName, "climax") and PlayFinish and (self.climaxStage < #self.climaxSequence)  then
			self.animationTimer = 0
			self.frameIndex = 1
			self.climaxStage = #self.climaxSequence 
			self.animationTimer = self.animationCycle * 0.9
		end
    
    -- Acquire the ID of the position
    local frame = self.frameName .. "." .. self.frameIndex 
    
    if (self.parts.actor1Body and self.parts.actor1Body:checkImageExists() and self.parts.actor2Body and self.parts.actor2Body:checkImageExists()) then --- TEMTEM: If there is no body pov, we go to else
        if (self.frameName == "position1" or self.frameName == "position1-climax" or -- For Standing, Doggy and Fellatio, layer Actor 2's body over their genitals, and the partner's genitals.
            self.frameName == "position2" or self.frameName == "position2-climax") then
            self.canvas:drawImage(self._config.backgroundImage, {0, 0}, 1.0, "white", false)
            self.parts.actor2Genital:render(self.canvas, frame)
            self.parts.actor1Body:render(self.canvas, frame)
            self.parts.actor1Genital:render(self.canvas, frame)
            self.parts.actor2Body:render(self.canvas, frame)
            -- self.parts.actor1LHand:render(self.canvas, frame) -- Hands are disabled due to lack of compatiblity
            -- self.parts.actor1RHand:render(self.canvas, frame) -- and generally covering the action.
            self.parts.actor1BodyOverlay:render(self.canvas, frame)
            self.canvas:drawImage(self._config.foregroundImage, {0, 0}, 1.0, self._config.foregroundImageColor, false)
            -- self.canvas:drawImage(self._config.recordFXImage, {0,0}, 1.0, "white", false)
    
        elseif (self.frameName == "position6" or self.frameName == "position6-climax" or 
            self.frameName == "position5" or self.frameName == "position5-climax") then
            self.canvas:drawImage(self._config.backgroundImage, {0, 0}, 1.0, "white", false)
            self.parts.actor2Back:render(self.canvas, frame) -- The back layer was added because of possible gaps in the animation.
            self.parts.actor1Genital:render(self.canvas, frame)
            self.parts.actor2Body:render(self.canvas, frame)
            self.parts.actor2Genital:render(self.canvas, frame)     -- Genital display during fellatio may not sound useful, but can display pregnancy.
            self.parts.actor2Hair:render(self.canvas, frame)        -- custom hair render.
            self.parts.actor1Body:render(self.canvas, frame)
            -- self.parts.actor2Genital:render(self.canvas, frame) -- irrelevant in these positions
            -- self.parts.actor1LHand:render(self.canvas, frame) -- Hands are disabled due to lack of compatiblity
            -- self.parts.actor1RHand:render(self.canvas, frame) -- and generally covering the action.
            self.parts.actor1BodyOverlay:render(self.canvas, frame)
            self.canvas:drawImage(self._config.foregroundImage, {0, 0}, 1.0, self._config.foregroundImageColor, false)
            -- self.canvas:drawImage(self._config.recordFXImage, {0,0}, 1.0, "white", false)
            
        else -- For all others, layer Actor 2's body under their genitals, and above the partner's genitals.  
            
            self.canvas:drawImage(self._config.backgroundImage, {0, 0}, 1.0, "white", false)
            self.parts.actor2Back:render(self.canvas, frame) -- The back layer was added because of possible gaps in the animation.
            self.parts.actor1Genital:render(self.canvas, frame) -- As such, it is not necessary, optional.
            self.parts.actor2Body:render(self.canvas, frame)
            self.parts.actor1Body:render(self.canvas, frame)
            self.parts.actor2Genital:render(self.canvas, frame)
            -- self.parts.actor1LHand:render(self.canvas, frame) -- Hands are disabled due to lack of compatiblity
            -- self.parts.actor1RHand:render(self.canvas, frame) -- and generally covering the action.
            self.parts.actor1BodyOverlay:render(self.canvas, frame)
            self.canvas:drawImage(self._config.foregroundImage, {0, 0}, 1.0, self._config.foregroundImageColor, false)
            -- self.canvas:drawImage(self._config.recordFXImage, {0,0}, 1.0, "white", false)
            
            
        end
    else --- TEMTEM: Else we are  rendering scenes.
		if string.find(frame, "climax") then
			if (self.climaxStage == 0) then 
				self.climaxStage = 1
			end
		end
		if not string.find(frame, "climax") then
			self.climaxStage = 0
			
		end -- TEMTEM2 climax prograssion/reset
		local t = {}
		for i = 1, #self.climaxSequence do
			t[i] = self.climaxSequence:sub(i, i) -- TEMTEM2 climax reads each letter of climaxSequence string and play that stage in order
		end
		if (not self.oldVersion) then
			frame = "pos." .. self.frameIndex -- TEMTEM2 Renaming frames to simpler format
		end
		if (self.climaxStage >= 1 and not self.oldVersion) then
			frame = "pos-climax.s" .. t[self.climaxStage].. "." .. self.frameIndex
		end
		
	
		self.canvas:drawImage(self._config.backgroundImage, {0, 0}, 1.0, "white", false)
		if not self.parts.actor1Scene:checkImageExists() then
			self.parts.actor2Scene:render(self.canvas, frame)
		else 
			self.parts.actor1Scene:render(self.canvas, frame)
		end
	end
end

--- Updates this instance
-- @param dt
function SexUI.POV:update(dt)
    self.animationTimer = self.animationTimer + dt
    local cycle = self.animationCycle / self.animationRate
    local configTemp
    local shouldLoop = true
	local oldframeName = self.frameName;
	self.frameName = "pos"

    if self.animationType == 0 then 
        self.frameIndex = util.clamp(math.ceil(self.animationTimer / cycle * self.frameCount), 1, self.frameCount)
        
        --[[self.actor1HandVariantTimer = self.actor1HandVariantTimer + dt              -- This will most likely be removed later (Narrator: And it indeed was)
        
        if (self.actor1HandVariantTimer >= self.actor1HandVariantChangeTimeout) then
            self.actor1HandLVariantIndex = math.random(1, 2)
            self.actor1HandRVariantIndex = math.random(1, 2)
            if (self.actor1HandLVariantIndex == self.actor1HandRVariantIndex) then
                self.actor1HandRVariantIndex = 1
            end
            self.actor1HandVariantTimer = 0
            self.actor1HandVariantChangeTimeout = math.max(15, math.random(60))
        end]]
        
    elseif self.animationType == 1 then 
        if (self.parts.actor2Scene and self.parts.actor2Scene:checkImageExists()) then
            if self.cutscene2Setup == false or self.Setup2Name ~= self.parts.actor2Scene.image then
                self.Setup2Name = self.parts.actor2Scene.image
                configTemp = (string.sub(self.parts.actor2Scene.image, 1, -4) .. "frames")
                self.cutscene2Setup = root.assetJson(configTemp)
            end
            if (self.cutscene2Setup.frameConfig) then
                if (self.cutscene2Setup.frameConfig[(self.frameName .. "-fc")]) then self.frameCount = self.cutscene2Setup.frameConfig[(self.frameName .. "-fc")] else self.frameCount = (self.cutscene2Setup.frameConfig["frame-count"] or 5) end
                if (self.cutscene2Setup.frameConfig[(self.frameName .. "-cr")]) then self.animationCycle = self.cutscene2Setup.frameConfig[(self.frameName .. "-cr")] else self.animationCycle = (self.cutscene2Setup.frameConfig["cycle-rate"] or (5/self.frameCount)) end
                if (self.cutscene2Setup.frameConfig[(self.frameName .. "-loop")] and self.cutscene2Setup.frameConfig[(self.frameName .. "-loop")] == "false") then shouldLoop = false end
                if (self.cutscene2Setup.frameConfig[(self.frameName .. "-sequence")]) then self.climaxSequence = self.cutscene2Setup.frameConfig[(self.frameName .. "-sequence")] end
            else
                self.frameCount = 5
                self.animationCycle = 1
            end
        elseif (self.parts.actor1Scene and self.parts.actor1Scene:checkImageExists()) then
            if self.cutscene1Setup == false or self.Setup1Name ~= self.parts.actor1Scene.image then
				self.Setup1Name = self.parts.actor1Scene.image
                configTemp = (string.sub(self.parts.actor1Scene.image, 1, -4) .. "frames")
                self.cutscene1Setup = root.assetJson(configTemp)
            end
            if (self.cutscene1Setup.frameConfig) then
                if (self.cutscene1Setup.frameConfig[(self.frameName .. "-fc")]) then self.frameCount = self.cutscene1Setup.frameConfig[(self.frameName .. "-fc")] else self.frameCount = (self.cutscene1Setup.frameConfig["frame-count"] or 5) end
                if (self.cutscene1Setup.frameConfig[(self.frameName .. "-cr")]) then self.animationCycle = self.cutscene1Setup.frameConfig[(self.frameName .. "-cr")] else self.animationCycle = (self.cutscene1Setup.frameConfig["cycle-rate"] or (5/self.frameCount)) end
                if (self.cutscene1Setup.frameConfig[(self.frameName .. "-loop")] and self.cutscene1Setup.frameConfig[(self.frameName .. "-loop")] == "false") then shouldLoop = false end
                if (self.cutscene1Setup.frameConfig[(self.frameName .. "-sequence")]) then self.climaxSequence = self.cutscene1Setup.frameConfig[(self.frameName .. "-sequence")] end
            else
                self.frameCount = 5
                self.animationCycle = 1
            end
        end
    end
    
    self.frameName = oldframeName
    if (self.animationTimer >= cycle) then
		if (self.climaxStage >= 1) then -- TEMTEM2 Progressing climax
			self.climaxStage = util.clamp(self.climaxStage + 1, 1, #self.climaxSequence)
		end
        if (shouldLoop == true) then 
            self.animationTimer = 0 else self.animationTimer = cycle end
    end
	self.frameIndex = util.clamp(math.ceil(self.animationTimer / cycle * self.frameCount), 1, self.frameCount)
end

--- Updates animation parts for each actor
-- @param a table of actors
function SexUI.POV:updateParts(actors)
    self.parts = {}
    self.partDirectives = {}

    if isEmpty(actors or {}) or #actors <= 1 then
        return
    end

    self:updatePenetrationType(actors)
    if self.animationType == 0 then
        self:updatePartsForActor1(actors[1])
        self:updatePartsForActor2(actors[2])
        if not self.parts.actor1Body:checkImageExists() or not self.parts.actor2Body:checkImageExists()  then
            self.animationType = 1
            self.parts = {}
            self.partDirectives = {}
            self.frameName = ""
            return
        end
    elseif self.animationType == 1 then
        self:updateCutscenes(actors[1])
        self:updateCutscenes(actors[2])
		self:updateSceneType(actors)
        if (not self.parts.actor2Scene:checkImageExists() and not self.parts.actor1Scene:checkImageExists()) then --- TEMTEM: Making sure pov is only disabled of none of the actors have scenes.
            self.parts = {}
            self.partDirectives = {}
            self.frameName = ""
            return
        end
    end

    self.frameName = actors[1].frameName
	self.mActor = actors
end

--- Updates animation parts for Actor1
-- @param actor an actor table
function SexUI.POV:updatePartsForActor1(actor)

    self.parts.actor1Body = SexUI.POV.Part.new(actor, "body")
    self.parts.actor1BodyOverlay = SexUI.POV.Part.new(actor, "body_overlay")
    --self.parts.actor1LHand = SexUI.POV.Part.new(actor, "hand_l_variant" .. self.actor1HandLVariantIndex)
    --self.parts.actor1RHand = SexUI.POV.Part.new(actor, "hand_r_variant" .. self.actor1HandRVariantIndex)

    --actor.gender = actor.genitalType
    self.parts.actor1Genital = SexUI.POV.Part.new(actor, "genital")
end

--- Updates animation parts for Actor 2
-- @param actor an actor table
function SexUI.POV:updatePartsForActor2(actor)
    --actor.gender =  actor.subGender or actor.gender or "male"
    
    self.parts.actor2Body = SexUI.POV.Part.new(actor, "body_penetration" .. self.penetrationType)
    self.parts.actor2Back = SexUI.POV.Part.new(actor, "back")
    self.parts.actor2Genital = SexUI.POV.Part.new(actor, "genital")
    self.parts.actor2Hair = SexUI.POV.Part.new(actor, "hair")
    if not self.parts.actor2Hair:checkImageExists() then
        self.parts.actor2Hair = SexUI.POV.Part.newHair(actor, "hair", true)
    end
end

--- Updates cutscene animations for TemTem's Cutscenes
-- @param actor, an actor table.
function SexUI.POV:updateCutscenes(actor)
    if actor.actorSlot == "actor1" then
		self.oldVersion = false -- temtem2 some weird shit magic I came up with to track whether both are using old version.  seems to work(?)
		self.parts.actor1Scene = SexUI.POV.Part.new(actor, string.gsub(actor.frameName, "-climax", "") .. "-cutscenes" .. self.ScenePenType)
		if not self.parts.actor1Scene:checkImageExists() then
			self.oldVersion = true
			self.parts.actor1Scene = SexUI.POV.Part.new(actor, "Cutscenes")
		end
		--- TEMTEM: Adding actor1 scene
    elseif actor.actorSlot == "actor2" then
		self.parts.actor2Scene = SexUI.POV.Part.new(actor, string.gsub(actor.frameName, "-climax", "") .. "-cutscenes" .. self.ScenePenType)
		if not self.parts.actor2Scene:checkImageExists() then
			self.parts.actor2Scene = SexUI.POV.Part.new(actor, "Cutscenes")
			else
			self.oldVersion = false
		end --- TEMTEM: Adding actor2 scene
    end
end

--- Updates the penetration type according to the genital type of actor 1 and 2
-- @param actors a table of actors
function SexUI.POV:updatePenetrationType(actors)
    local actor1Gender = actors[1].subGender or actors[1].gender or "male"
    local actor2Gender = actors[2].subGender or actors[2].gender or "male"

    -- genital type 0 = male; genital type 1 = female
    if (actor1Gender == "female" or actor1Gender == "cuntboy") then
        self.penetrationType = 1
        return
    end
    if (actor1Gender == "male" or actor1Gender == "futanari") and (actor2Gender == "female" or actor2Gender == "cuntboy" or actor2Gender == "futanari") then
        self.penetrationType = 2
        return
    end
    if (actor1Gender == "male" or actor1Gender == "futanari") and actor2Gender == "male" then
        self.penetrationType = 3
        return
    end
    self.penetrationType = 1
end

function SexUI.POV:updateSceneType(actors)
    local actor1Gender = actors[1].subGender or actors[1].gender or "male"
    local actor2Gender = actors[2].subGender or actors[2].gender or "male"
	self.ScenePenType = 1
    -- genital type 0 = male; genital type 1 = female
    if (actor2Gender == "female" or actor2Gender == "cuntboy") and (actor1Gender == "female") then
        self.ScenePenType = 4
	end
	if (actor2Gender == "futanari") and (actor1Gender == "female") then
        self.ScenePenType = 5
	end
	if (actor2Gender == "male") and (actor1Gender == "female") then
        self.ScenePenType = 6
	end
    if (actor2Gender == "female" or actor2Gender == "cuntboy") and (actor1Gender == "male" or actor1Gender == "futanari") then
        self.ScenePenType = 1
	end
	if (actor2Gender == "futanari") and (actor1Gender == "male" or actor1Gender == "futanari") then
        self.ScenePenType = 2
	end
	if (actor2Gender == "male") and (actor1Gender == "male" or actor1Gender == "futanari") then
        self.ScenePenType = 3
	end   
end

--- Sets animation rate to the specified value
-- @param animationRate a decimal number
function SexUI.POV:setAnimationRate(animationRate)
    self.animationRate = animationRate
end

--- Returns a reference to the UI canvas
function SexUI.POV:getCanvas()
    return self.canvas
end
